PROGRAM_NAME='Demo Program'
/////////////////////////////////////////////////////////////
//                                                         //
//      Copyright (c) 2023 Janus Technology Limited        //
//                                                         //
/////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////
//                  Define Device                          //
/////////////////////////////////////////////////////////////
DEFINE_DEVICE

// Touch screen for demo application..
dvTP 		= 11001:1:0;
dvTP_Mix1	= 11001:2:0;
dvTP_Mix2	= 11001:3:0;
dvTP_Mix3 	= 11001:4:0;
dvTP_Mix4 	= 11001:5:0;
dvTP_Mix5 	= 11001:6:0;
dvTP_Mix6 	= 11001:7:0;
dvTP_Mix7 	= 11001:8:0;
dvTP_Mix8 	= 11001:9:0;


// IP Port to use for amp..
dvAmp 		= 0:11:0;

vdvTP 		= 33001:1:0;

// Virtual device for amp..
vdvAmp 		= 33333:1:0;
vdvAmpMixer1	= 33333:2:0;
vdvAmpMixer2	= 33333:3:0;
vdvAmpMixer3 	= 33333:4:0;
vdvAmpMixer4 	= 33333:5:0;
vdvAmpMixer5	= 33333:6:0;
vdvAmpMixer6	= 33333:7:0;
vdvAmpMixer7	= 33333:8:0;
vdvAmpMixer8	= 33333:9:0;

// Virtual device for debug info..
vdvDebug 	= 0:1:0;

/////////////////////////////////////////////////////////////
//                  Debug	                           //
/////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////
//                  Constants                              //
/////////////////////////////////////////////////////////////
DEFINE_CONSTANT

// Channels
integer driverConnected = 1;
integer devicePoweredOn = 2;
integer devicePower	    = 3;
integer inputStereo_ab	= 4;
integer inputStereo_cd 	= 5;
integer zoneStereo_ab	= 6;
integer zoneStereo_cd 	= 7;

// Channel to indicate zone is Clipping
integer inputZoneClipping[] = { 31 , 32 , 33 , 34 }

// Levels for Zone and input signal levels
integer zoneDynSignalLevel[] = { 51 , 52, 53 , 54}
integer inputDynSignalLevel[] = { 61 , 62, 63 , 64}

// Levels
integer zoneLevelControl[] = { 101 , 102 , 103 , 104 , 105 , 106 , 107 , 108 }
integer zoneLevelFeedback[] = { 151 , 152 , 153 , 154 , 155 , 156 , 157 , 158 }

integer mixLevelControl[] =  { 201 , 202 , 203 , 204 , 205 , 206 , 207 , 208 , 209 , 210 , 211 , 212 , 213 , 214 , 215 , 216 , 217 , 218 }
integer mixLevelFeedback[] = { 251 , 252 , 253 , 254 , 255 , 256 , 257 , 258 , 259 , 260 , 261 , 262 , 263 , 264 , 265 , 266 , 267 , 268 }

integer zoneMuteControl[] = { 101 , 102 , 103 , 104 , 105 , 106 , 107 , 108 }
integer zoneMuteDisplay[] = { 151 , 152 , 153 , 154 , 155 , 156 , 157 , 158 }

// Demo Buttons
integer switchExamples[] = { 11 , 12 , 13 , 14 , 15 , 16 , 17 , 18  }
integer powerOn = 21
integer powerOff = 22

// Switch Inputs
integer inAnalog1 = 1;
integer inAnalog2 = 2;
integer inAnalog3 = 3;
integer inAnalog4 = 4;
integer inSpdif1  = 5;
integer inSpdif2  = 6;
integer inMix1    = 7;
integer inMix2    = 8;
integer inMix3    = 9;
integer inMix4    = 10;
integer inMix5    = 19;
integer inMix6    = 20;
integer inMix7    = 21;
integer inMix8    = 22;
integer inDante1  = 11;
integer inDante2  = 12;
integer inDante3  = 13;
integer inDante4  = 14;
integer inAnalog5 = 15;
integer inAnalog6 = 16;
integer inAnalog7 = 17;
integer inAnalog8 = 18;

// Switch Outputs
integer outZoneA  = 1; 
integer outZoneB  = 2;
integer outZoneC  = 3; 
integer outZoneD  = 4;

// 8 Zone units only.
integer outZoneE  = 5; 
integer outZoneF  = 6;
integer outZoneG  = 7; 
integer outZoneH  = 8; 

/////////////////////////////////////////////////////////////
//                  Structures                             //
/////////////////////////////////////////////////////////////
DEFINE_TYPE

/////////////////////////////////////////////////////////////
//                  Variables                              //
/////////////////////////////////////////////////////////////
DEFINE_VARIABLE

char ampIpAddress[] = '172.16.112.204';

// first in array Output , Second Input
integer exampleSwitches[][] = {
	{outZoneA , inAnalog1},
	{outZoneA , inAnalog2},
	{outZoneC , inAnalog1},
	{outZoneC , inSpdif1},
	{outZoneA , inMix1},
	{outZoneA , inMix2},
	{outZoneA , inDante1},
	{outZoneC , inDante2}
}

/////////////////////////////////////////////////////////////
//                  Functions/Calls                        //
/////////////////////////////////////////////////////////////

define_function combileChannels()
{
	combine_channels(vdvAmp ,driverConnected , dvTP, driverConnected)
	combine_channels(vdvAmp ,devicePoweredOn , dvTP, devicePoweredOn)
	combine_channels(vdvAmp ,inputStereo_ab , dvTP, inputStereo_ab)
	combine_channels(vdvAmp ,inputStereo_cd , dvTP, inputStereo_cd)
	combine_channels(vdvAmp ,zoneStereo_ab , dvTP, zoneStereo_ab)
	combine_channels(vdvAmp ,zoneStereo_cd , dvTP, zoneStereo_cd)
	
}
/////////////////////////////////////////////////////////////
// fnUpdatePowerFeedback - Update Power UI on TP online..
define_function combineLevels()
{
	integer i;

	// Combine Zone Levels
	for(i = 1; i <= length_array(zoneLevelControl); i++)
	{
		combine_levels 	(vdvAmp,zoneLevelControl[i],dvTP,zoneLevelControl[i])
		combine_levels 	(vdvAmp,zoneLevelFeedback[i],dvTP,zoneLevelFeedback[i])
	}
	
	// Combine Mix 1 Levels
	for(i = 1; i <= length_array(mixLevelControl); i++)
	{
		combine_levels 	(vdvAmpMixer1,mixLevelControl[i],dvTP_Mix1,mixLevelControl[i])
		combine_levels 	(vdvAmpMixer1,mixLevelFeedback[i],dvTP_Mix1,mixLevelFeedback[i])
	}
	
	// Combine Mix 2 Levels
	for(i = 1; i <= length_array(mixLevelControl); i++)
	{
		combine_levels 	(vdvAmpMixer2,mixLevelControl[i],dvTP_Mix2,mixLevelControl[i])
		combine_levels 	(vdvAmpMixer2,mixLevelFeedback[i],dvTP_Mix2,mixLevelFeedback[i])
	}
	
	// Combine Mix 3 Levels
	for(i = 1; i <= length_array(mixLevelControl); i++)
	{
		combine_levels 	(vdvAmpMixer3,mixLevelControl[i],dvTP_Mix3,mixLevelControl[i])
		combine_levels 	(vdvAmpMixer3,mixLevelFeedback[i],dvTP_Mix3,mixLevelFeedback[i])
	}
	
	// Combine Mix 4 Levels
	for(i = 1; i <= length_array(mixLevelControl); i++)
	{
		combine_levels 	(vdvAmpMixer4,mixLevelControl[i],dvTP_Mix4,mixLevelControl[i])
		combine_levels 	(vdvAmpMixer4,mixLevelFeedback[i],dvTP_Mix4,mixLevelFeedback[i])
	}
	
	// Combine Mix 8 Levels
	for(i = 1; i <= length_array(mixLevelControl); i++)
	{
		combine_levels 	(vdvAmpMixer8,mixLevelControl[i],dvTP_Mix8,mixLevelControl[i])
		combine_levels 	(vdvAmpMixer8,mixLevelFeedback[i],dvTP_Mix8,mixLevelFeedback[i])
	}
}

define_function processSwitchString (char str[255]) {
    integer input,output;
    char process[8]

    // "'SW ', itoa( Output ), '=', itoa( Input ), ';'";
    
    if(find_string(str,'SW ',1) && find_string(str,';',1)) {
		remove_string(str,'SW ',1)
		
		process = remove_string(str,'=',1)
		
		set_length_string(process,length_string(process) - 1)
		
		output = atoi(process)
		
		process = str
		
		set_length_string(process,length_string(process) - 1)
		
		input = atoi(process)
		
		updateSwitchFeedback(output , input)
    }
}

define_function updateSwitchFeedback(integer output , integer input)
{
	integer i;
	
	for(i = 1; i <= length_array(exampleSwitches); i++)
	{
		// Turn off if output is correct but input is not
		if(exampleSwitches[i][1] = output && input != exampleSwitches[i][2])
		{
			off[dvTP,switchExamples[i]]
		}
		// Turn on if output and input are correct
		else if(exampleSwitches[i][1] = output && input = exampleSwitches[i][2])
		{
			on[dvTP,switchExamples[i]]
		}
	}
}
/////////////////////////////////////////////////////////////
//                  StartUp                                //
/////////////////////////////////////////////////////////////
DEFINE_START

combileChannels()
combineLevels()

// Define Module..
define_module 'Integra_DSP_Comms' amp1 (vdvAmp , dvAmp , ampIpAddress , vdvDebug)

/////////////////////////////////////////////////////////////
//                  Event's                                //
/////////////////////////////////////////////////////////////
DEFINE_EVENT

data_event[vdvAmp]
{
	online:
	{

	}
	string:
	{
		processSwitchString(data.text);
	}

}

button_event[dvTP,zoneMuteControl]
{
	push:
	{
		integer btn
		
		btn = get_last(zoneMuteControl)
		
		if([vdvAmp,zoneMuteDisplay[btn]])
		{
		    off[vdvAmp,zoneMuteControl[btn]]
		}
		else
		{
		    on[vdvAmp,zoneMuteControl[btn]]
		}
	}
}

button_event[dvTP,powerOn]
{
	push:
	{
		on[vdvAmp,devicePower]
	}
}

button_event[dvTP,powerOff]
{
	push:
	{
		off[vdvAmp,devicePower]
	}
}

channel_event[vdvAmp,zoneMuteDisplay]
{
	on:
	{
		integer chan
		
		chan = get_last(zoneMuteDisplay)
		
		on[dvTP,zoneMuteControl[chan]]
	}
	off:
	{
		integer chan
		
		chan = get_last(zoneMuteDisplay)
		
		off[dvTP,zoneMuteControl[chan]]
	}
}

button_event[dvTP,switchExamples]
{
	push:
	{
		integer btn;
		
		btn = get_last(switchExamples)
		
		if(btn <= length_array(exampleSwitches))
		{
			send_command vdvAmp,"'SW ',itoa(exampleSwitches[btn][1]),'=',itoa(exampleSwitches[btn][2]),';'"
		}
	}
}


/////////////////////////////////////////////////////////////
//                  MainLine                               //
/////////////////////////////////////////////////////////////
DEFINE_PROGRAM

/////////////////////////////////////////////////////////////
//                  The End                                //
/////////////////////////////////////////////////////////////

